/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.Trace;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class TracePrintStream
extends PrintStream {
    public TracePrintStream(String filename) {
        super(new TraceOutputStream(filename), true);
        if (filename == "!STD") {
            System.setOut(new PrintStream(new FileOutputStream(FileDescriptor.out)));
            System.setErr(new PrintStream(new FileOutputStream(FileDescriptor.err)));
        } else {
            System.setOut(this);
            System.setErr(this);
        }
    }

    public TracePrintStream() {
        this((String)null);
    }

    private static class TraceOutputStream
    extends OutputStream {
        private FileOutputStream fs;
        private byte[] buf;
        private int pos;
        private static final String prefix = "XFM!!!!F";

        private TraceOutputStream(String filename) {
            block2: {
                this.fs = null;
                this.buf = new byte[1014];
                this.pos = 0;
                if (Trace.isLibraryLoaded() || filename == null) break block2;
                try {
                    this.fs = new FileOutputStream(filename);
                }
                catch (Exception e) {
                    System.out.println("Exception opening output file [" + filename + "]: " + e);
                    e.printStackTrace();
                }
            }
        }

        public void close() throws IOException {
            if (this.fs != null) {
                this.fs.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            if (!Trace.isLibraryLoaded()) {
                if (this.fs != null) {
                    this.fs.flush();
                }
            } else {
                TraceOutputStream traceOutputStream = this;
                synchronized (traceOutputStream) {
                    if (this.pos > 0) {
                        Trace.trace(prefix, new String(this.buf, 0, this.pos));
                        this.pos = 0;
                    }
                }
            }
        }

        public void write(int b) throws IOException {
            if (!Trace.isLibraryLoaded()) {
                if (this.fs != null) {
                    this.fs.write(b);
                }
            } else {
                byte[] bb = new byte[]{(byte)b};
                this.write(bb, 0, 1);
            }
        }

        public void write(byte[] b) throws IOException {
            if (!Trace.isLibraryLoaded()) {
                if (this.fs != null) {
                    this.fs.write(b);
                }
            } else {
                this.write(b, 0, b.length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int off, int len) throws IOException {
            if (!Trace.isLibraryLoaded()) {
                if (this.fs != null) {
                    this.fs.write(b, off, len);
                }
            } else {
                TraceOutputStream traceOutputStream = this;
                synchronized (traceOutputStream) {
                    int i = 0;
                    while (i < len) {
                        this.buf[this.pos] = b[off + i];
                        ++this.pos;
                        if (this.pos == this.buf.length) {
                            Trace.trace(prefix, new String(this.buf, 0, this.pos));
                            this.pos = 0;
                        }
                        ++i;
                    }
                }
            }
        }
    }
}

